//
//  SubForm04ViewController.m
//  iOS SDK Sample
//
//  Created by NEI アプリGr on 2013/07/05.
//  Copyright (c) 2013年 Nippon Primex Inc. All rights reserved.
//

#import "SubForm04ViewController.h"


@interface SubForm04ViewController ()

@end

@implementation SubForm04ViewController

@synthesize objLib = mObjLib;
@synthesize strPrtName = mStrPrtName;
@synthesize sclView = mSclView;

-(void) btnViewSetting : (UIButton *) btnObj
{
    NSString* osversion = [UIDevice currentDevice].systemVersion;
    NSArray* a = [osversion componentsSeparatedByString:@"."];
    
    if([(NSString*)[a objectAtIndex:0] intValue] >= 7)
    {
        btnObj.layer.borderColor = [UIColor blueColor].CGColor;
        btnObj.layer.borderWidth = 1.0f;
        btnObj.layer.cornerRadius = 7.5f;
        
        btnObj.backgroundColor = [UIColor colorWithRed:0.95 green:1.0 blue:1.0 alpha:1.0];
        [btnObj setTintColor:[UIColor blackColor]];
    }
}

-(void) setReturnCode :(int) nmsResult
{
    lblReturnCode.text = [NSString stringWithFormat:@"Return Code: %d", nmsResult];

    if(nmsResult != 0)
    {
        lblReturnCode.textColor = [UIColor redColor];
    }
    else
    {
        lblReturnCode.textColor = [UIColor blackColor];
    }
}

- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil
{
    self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil];
    if (self) {
        // Custom initialization
    }
    return self;
}

-(void) appClose
{
    [mObjLib NClosePrinters];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view.
    
    [self btnViewSetting:btnNResetPrinter];
    [self btnViewSetting:btnNFirmwareDL];
    [self btnViewSetting:btnNFirmwareCheck];
    [self btnViewSetting:btnBack];
    
    
    txtFwfFile.delegate = self;
    txtCheckSum.delegate = self;
    
    // App close setting(Enter backgroud)
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(appClose)
                                                 name:UIApplicationDidEnterBackgroundNotification object:nil];
}

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


- (IBAction)pushBtnNResetPrinter:(UIButton *)sender
{
    int nmsRet = 0;
    
    // comment:NPI NResetPrinter(Not supported)
    nmsRet = [mObjLib NResetPrinter: mStrPrtName];
    
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnNFirmwareDL:(UIButton *)sender
{
    int nmsRet = 0;
    short io_chksum = 0;
    int io_jobid = 0;
    NSString* strFwfFile = [txtFwfFile text];
    
    if([strFwfFile isEqualToString:@""])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Enter the Fwf file."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return;
    }
    
    if([[strFwfFile pathExtension] caseInsensitiveCompare:@"fwf"] != NSOrderedSame)
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Not Fwf file."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return;
    }
    
    NSArray* items = [strFwfFile componentsSeparatedByString:@"."];
    
    NSString* filePath = [[NSBundle mainBundle] pathForResource:[items objectAtIndex:0] ofType:[items objectAtIndex:1]];
    
    // comment:NPI NFirmwareDL(Not supported)
    nmsRet = [mObjLib NFirmwareDL: mStrPrtName :filePath :swtErrorCheck.on :&io_chksum : &io_jobid];
    
    
    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnCheckSum:(UIButton *)sender
{
    int nmsRet = 0;
    short io_chksum = 0;

    unsigned int tmpChksum = 0;
    int io_jobid = 0;
    
    NSString* strCheckSum = [txtCheckSum text];
    
    if([strCheckSum isEqualToString:@""])
    {
        UIAlertView* alert = [[UIAlertView alloc]
                              initWithTitle:@""
                              message:@"Enter the check sum."
                              delegate:nil
                              cancelButtonTitle:@"OK"
                              otherButtonTitles:nil];
        
        [alert show];
        return;
    }
    

    
    [[NSScanner scannerWithString:strCheckSum] scanHexInt:&tmpChksum];
    
    io_chksum = tmpChksum;
    
    // comment:NPI NFirmwareDL(Not supported)
    nmsRet = [mObjLib NFirmwareDL: mStrPrtName :nil :swtErrorCheck.on :&io_chksum : &io_jobid];

    [self setReturnCode:nmsRet];
}

- (IBAction)pushBtnBack:(UIButton *)sender
{
    [self dismissViewControllerAnimated:YES completion:nil];    
}


-(BOOL)textFieldShouldReturn:(UITextField*) textField {
    [textField resignFirstResponder];
    return YES;
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    
    // キーボード表示・非表示時のイベント登録
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasShown:)
                                                 name:UIKeyboardDidShowNotification object:nil];
    
    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(keyboardWasHidden:)
                                                 name:UIKeyboardDidHideNotification object:nil];
}

- (void)viewWillDisappear:(BOOL)animated {
    // キーボード表示・非表示時のイベント削除
    [[NSNotificationCenter defaultCenter] removeObserver:self];
}

- (void)keyboardWasShown:(NSNotification *)notification {
    NSDictionary *info = [notification userInfo];
    CGSize kbSize = [[info objectForKey:UIKeyboardFrameBeginUserInfoKey] CGRectValue].size;
    
    UIEdgeInsets contentInsets = UIEdgeInsetsMake(0.0, 0.0, kbSize.height, 0.0);
    
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
    
    CGRect aRect = self.view.frame;
    aRect.size.height -= kbSize.height;
    if (_activeField != nil) {
        CGPoint scrollPoint = CGPointMake(0.0, _activeField.frame.origin.y - 30);
        [self.sclView setContentOffset:scrollPoint animated:YES];
    }
}

- (void)keyboardWasHidden:(NSNotification *)notification {
    UIEdgeInsets contentInsets = UIEdgeInsetsZero;
    self.sclView.contentInset = contentInsets;
    self.sclView.scrollIndicatorInsets = contentInsets;
}

- (void)textFieldDidBeginEditing:(UITextField *)textField {
    _activeField = textField;
}

- (void)textFieldDidEndEditing:(UITextField *)textField {
    _activeField = nil;
}


@end
